Attribute VB_Name = "modBracerMatcher"
Option Explicit

Public Function MatchBracers()
' run when Ctrl+\ is used (find matching bracer)

    Dim sMainSpew As Variant
     sMainSpew = frmMain.rtfMain.Text
    Dim nOrigin As Long
     nOrigin = frmMain.rtfMain.SelStart 'original position
    Dim nPos As Long
    Dim nCount As Long 'holds counter
     nCount = 0 'zero by default, 1 when it finds first bracer (initial one), minus -1 on finding opposite bracer
               '+1 on finding same type of bracer. When it = 0 match is found
    Dim sSpew As String 'hold current (origin) cursor character
     sSpew = Mid(sMainSpew, nOrigin + 1, 1)
     
    Dim msg As String 'alert spew
    
    
    
    If sSpew = "{" Then
        nPos = nOrigin + 2
        nCount = nCount + 1
        While nCount <> 0 And nPos <= Len(sMainSpew)
            If Mid(sMainSpew, nPos, 1) = "{" Then
                nCount = nCount + 1 'it's another "{" increment counter
            ElseIf Mid(sMainSpew, nPos, 1) = "}" Then
                nCount = nCount - 1 'it's the opposite bracer
            End If
            nPos = nPos + 1
        Wend
        If nCount = 0 Then 'reset the cursor to new spot
            frmMain.rtfMain.SelStart = nPos - 2
            frmMain.rtfMain.SelLength = 1
        Else 'no match found!
            msg = "Unable to find a matching bracer!"
            msg = MsgBox(msg, vbOKOnly)
            frmMain.rtfMain.SelLength = 1
        End If
    
    ElseIf sSpew = "}" Then
        nPos = nOrigin '- 1
        nCount = nCount + 1
        While nCount <> 0 And nPos > 1
            If Mid(sMainSpew, nPos, 1) = "}" Then
                nCount = nCount + 1 'it's another "{" increment counter
            ElseIf Mid(sMainSpew, nPos, 1) = "{" Then
                nCount = nCount - 1 'it's the opposite bracer
            End If
            nPos = nPos - 1
        Wend
        If nCount = 0 Then
            frmMain.rtfMain.SelStart = nPos
            frmMain.rtfMain.SelLength = 1
        Else 'no match found!
            msg = "Unable to find a matching bracer!"
            msg = MsgBox(msg, vbOKOnly)
            frmMain.rtfMain.SelLength = 1
        End If
    
        
    ElseIf sSpew = "(" Then
        nPos = nOrigin + 2
        nCount = nCount + 1
        While nCount <> 0 And nPos <= Len(sMainSpew)
            If Mid(sMainSpew, nPos, 1) = "(" Then
                nCount = nCount + 1 'it's another "{" increment counter
            ElseIf Mid(sMainSpew, nPos, 1) = ")" Then
                nCount = nCount - 1 'it's the opposite bracer
            End If
            nPos = nPos + 1
        Wend
        If nCount = 0 Then
            frmMain.rtfMain.SelStart = nPos - 2
            frmMain.rtfMain.SelLength = 1
        Else 'no match found!
            msg = "Unable to find a matching bracer!"
            msg = MsgBox(msg, vbOKOnly)
            frmMain.rtfMain.SelLength = 1
        End If
            
    
    ElseIf sSpew = ")" Then
        nPos = nOrigin '- 1
        nCount = nCount + 1
        While nCount <> 0 And nPos > 1
            If Mid(sMainSpew, nPos, 1) = ")" Then
                nCount = nCount + 1 'it's another "{" increment counter
            ElseIf Mid(sMainSpew, nPos, 1) = "(" Then
                nCount = nCount - 1 'it's the opposite bracer
            End If
            nPos = nPos - 1
        Wend
        If nCount = 0 Then
            frmMain.rtfMain.SelStart = nPos
            frmMain.rtfMain.SelLength = 1
        Else 'no match found!
            msg = "Unable to find a matching bracer!"
            msg = MsgBox(msg, vbOKOnly)
            frmMain.rtfMain.SelLength = 1
        End If
    
    Else
    
    Dim sTemp As String
    sTemp = "Place the cursor just BEFORE a bracer" & vbCrLf _
                & "Notice the happy cursor in the example below:" & vbCrLf & vbCrLf _
                & "/action {Joe says, '%0'} {do this;/var {yuck} {do that};do stuff} {}" _
                & vbCrLf
        frmPopUp.txtMain.Text = sTemp
        frmPopUp.txtMain.Font = "Courier New"
        frmPopUp.txtMain.FontSize = "9"
        frmPopUp.txtMain.FontBold = False
        frmPopUp.txtMain.SelStart = 127
        frmPopUp.Caption = "MM Edit - Elementary Cursor Positioning 101"
        frmPopUp.Show
    End If

End Function

Public Function FindBracer(i As Integer)
    'i=index of the menu choice, 0=reverse|1=forward search
    
    Dim sSpew As Variant 'hold rtf txt box contents
     sSpew = frmMain.rtfMain.Text
    Dim nPos As Long 'hold cursor position
     nPos = frmMain.rtfMain.SelStart 'defauts to current cursor pos, +2 cuz Mid isn't 0 based :p
    Dim nLen As Long 'holds len of txt box contents
     nLen = Len(sSpew)
     
    If i = 1 Then 'we're searching forward
        nPos = nPos + 2 'need to bump it initially cuz Mid isn't 0 based
        While nPos <= nLen
            
            If InStr("{}()", Mid(sSpew, nPos, 1)) Then
                frmMain.rtfMain.SelStart = nPos - 1
                frmMain.rtfMain.SelLength = 1
                nPos = nLen + 1 'set nPos to 1 over nLen to abort more whiling
            Else
                nPos = nPos + 1
            End If
        Wend
    
    ElseIf i = 0 Then 'we're searching in reverse
        nPos = nPos
        While nPos > 1
            If InStr("{}()", Mid(sSpew, nPos, 1)) Then
                frmMain.rtfMain.SelStart = nPos - 1
                frmMain.rtfMain.SelLength = 1
                nPos = 0 '0 to abort more whiling
            Else
                nPos = nPos - 1
            End If
        Wend
    End If

End Function

Public Function Bracer_CheckSelection(n As Long, s As String, bFlag As Boolean)
'where "nOrigin"= Cursor Pos in rtfMain || sSpew is the selected text string

    frmMain.rtfMain.Locked = True
    Dim nLen As Long 'Len of sSpew
    Dim nBPos As Long 'position we're working from (bracer we're checking for matches on)
    Dim nTempPos As Long 'used for temporary increments to walk the string looking for matches to chr at nBPos
    Dim nTtlPos As Long 'total position we've moved through string, used by the main while
    Dim nBracerCount As Integer 'count bracers, 0=match found
    Dim sChr As String 'MID of chr at nBPos
    Dim msg As String 'for msgbox spew
    Dim nCurlyBCount As Long 'counts how many curlies were checked "{}"
    Dim nNormalBCount As Long 'counts how many bracers found "()"
    
    nLen = Len(s)
    nBPos = 1
    nTempPos = 1
    nTtlPos = 1
    nBracerCount = 0
    nCurlyBCount = 0
    nNormalBCount = 0
    'deselect the spew for appearances..
    'frmMain.rtfMain.SelStart = n
    

    While nTtlPos >= 1 And nTtlPos <= nLen
        sChr = Mid(s, nTtlPos, 1)
    
        If sChr = "{" Then
            nBracerCount = 1
            nCurlyBCount = nCurlyBCount + 1
            nBPos = nTtlPos
            nTempPos = nBPos + 1 'move the temp pos up one and start checking for a match
            While nTempPos <= nLen And nBracerCount <> 0
                sChr = Mid(s, nTempPos, 1)
                If bFlag = True Then
                    frmMain.rtfMain.SelStart = n + nTempPos
                    frmMain.rtfMain.SelLength = 1
                End If
                If sChr = "{" Then
                    nBracerCount = nBracerCount + 1
                ElseIf sChr = "}" Then
                    nBracerCount = nBracerCount - 1
                End If
                nTempPos = nTempPos + 1
            Wend
            
        ElseIf sChr = "(" Then
            nBracerCount = 1
            nNormalBCount = nNormalBCount + 1
            nBPos = nTtlPos
            nTempPos = nBPos + 1 'move the temp pos up one and start checking for a match
            While nTempPos <= nLen And nBracerCount <> 0
                sChr = Mid(s, nTempPos, 1)
                If sChr = "(" Then
                    nBracerCount = nBracerCount + 1
                ElseIf sChr = ")" Then
                    nBracerCount = nBracerCount - 1
                End If
                nTempPos = nTempPos + 1
            Wend
            
        ElseIf sChr = "}" Then
            nBracerCount = 1
            nCurlyBCount = nCurlyBCount + 1
            nBPos = nTtlPos
            nTempPos = nBPos - 1 'move the temp pos up one and start checking for a match
            While nTempPos >= 1 And nBracerCount <> 0
                sChr = Mid(s, nTempPos, 1)
                If bFlag = True Then
                    frmMain.rtfMain.SelStart = n + nTempPos
                    frmMain.rtfMain.SelLength = 1
                End If
                If sChr = "}" Then
                    nBracerCount = nBracerCount + 1
                ElseIf sChr = "{" Then
                    nBracerCount = nBracerCount - 1
                End If
                nTempPos = nTempPos - 1
            Wend
            
        ElseIf sChr = ")" Then
            nBracerCount = 1
            nNormalBCount = nNormalBCount + 1
            nBPos = nTtlPos
            nTempPos = nBPos - 1 'move the temp pos up one and start checking for a match
            While nTempPos >= 1 And nBracerCount <> 0
                sChr = Mid(s, nTempPos, 1)
                If bFlag = True Then
                    frmMain.rtfMain.SelStart = n + nTempPos
                    frmMain.rtfMain.SelLength = 1
                End If
                If sChr = ")" Then
                    nBracerCount = nBracerCount + 1
                ElseIf sChr = "(" Then
                    nBracerCount = nBracerCount - 1
                End If
                nTempPos = nTempPos - 1
            Wend
            
        End If
        
        If nBracerCount <> 0 Then 'no mis-match found
            frmMain.rtfMain.SelStart = (n + nBPos) - 1
            frmMain.rtfMain.SelLength = 1
            msg = MsgBox("No matching bracer located!" & vbCrLf & "Hit 'Ok' to continue checking, or 'Cancel' to abort", vbOKCancel + vbCritical, "Mis-Matched Bracer!")
                If msg = vbCancel Then
                    frmMain.rtfMain.Locked = False
                    Exit Function
                Else
                    nBracerCount = 0
                End If
                
        End If

        nTtlPos = nTtlPos + 1
    Wend
    frmMain.rtfMain.SelStart = n
    MsgBox "Finished checking selected text." & vbCrLf & vbCrLf _
        & nCurlyBCount & " Curly Bracers checked" & vbCrLf _
        & nNormalBCount & " Bracers checked" & vbCrLf _
        & nCurlyBCount + nNormalBCount & " Total bracers checked.", vbOKOnly, "Mismatched Bracer Checker"
    
    frmMain.rtfMain.Locked = False
End Function

