Attribute VB_Name = "modCompiler"
Option Explicit

Public Function Compile()


    If Len(frmMain.rtfMain.Text) <> 0 Then
    
        If frmMain.sActiveFileName = "" Then
            MsgBox "The current document you're working on has no" & vbCrLf _
             & "Path\filename. I will only compile files with a known path." & vbCrLf _
             & "Either save your document, or open an existing file." & vbCrLf _
             & "Aborting....", vbOKOnly, "eep!"
            Exit Function
        End If
    
        Dim nScriptFileNum As Integer 'freefile number for script file (input)
        Dim sLineText As String 'spew from file...
        Dim sTempPuzzle As String 'used to construct command from scattered parts
        Dim sCompiledSpew As String 'compiled result, once done stuff into rtf box.
        Dim sNewFileName As String 'sActiveFileName+.mme
        
        'FLAGS...
        Dim sBuildingCommand As String 'flag if we're working on a command, notes will be ignored (internal)
         sBuildingCommand = False 'false by default, we'll check for notes first
        Dim sStream As String 'uses "/&" to stream any line as a new line until "/*" is encountered.
         sStream = False
        
        sNewFileName = frmMain.sActiveFileName & ".mme" 'name new file string
        frmMain.rtfMain.SaveFile sNewFileName, rtfText 'save the current editor text as plain text
        nScriptFileNum = FreeFile
        
        Open sNewFileName For Input As nScriptFileNum 'open the just created file for parsing..
            
            While Not EOF(nScriptFileNum)
                Line Input #nScriptFileNum, sLineText
                
                'Kill Leading Tab(s)
                If InStr(sLineText, Chr(9)) Then
                    sLineText = Replace(sLineText, Chr(9), " ")
                End If
                
                sLineText = LTrim(sLineText) 'trim any leading spaces
                
                If Len(sLineText) > 0 And Mid(sLineText, 1, 1) <> vbCrLf Then 'if the Len is 1+ do stuff :p
                     
                     'it's a note (and not an internal note) and we're adding it, if flagged to
                    If Mid(sLineText, 1, 2) = "/~" And frmMain.mnuCompileAddNotes.Checked = True _
                     And sBuildingCommand = False Then
                        sCompiledSpew = sCompiledSpew & "/var {--NOTE--} {" _
                         & Trim(Mid(sLineText, 3, Len(sLineText) - 2)) & "}" & vbCrLf
                    
                    
                    'not building yet, so initialize it...
                    ElseIf Mid(sLineText, 1, 1) = "/" And Mid(sLineText, 1, 2) <> "/*" _
                        And Mid(sLineText, 1, 2) <> "/~" And Mid(sLineText, 1, 2) <> "/&" _
                        And sStream = False And sBuildingCommand = False Then
                        sBuildingCommand = True
                        sTempPuzzle = sLineText
                    
                    'already building so add to it...
                    ElseIf Mid(sLineText, 1, 2) <> "/*" And Mid(sLineText, 1, 2) <> "/&" _
                        And Mid(sLineText, 1, 2) <> "/~" And sStream = False And sBuildingCommand = True Then
                        sTempPuzzle = sTempPuzzle & sLineText
                        
                    ElseIf Mid(sLineText, 1, 2) = "/&" Then
                        sStream = True 'streaming commands
                        
                    'we're streaming... add all new lines
                    ElseIf sStream = True And Mid(sLineText, 1, 2) <> "/*" And Mid(sLineText, 1, 2) <> "/~" Then
                        sCompiledSpew = sCompiledSpew & sLineText & vbCrLf
                        
                                
                    'else it's close of command
                    ElseIf Mid(sLineText, 1, 2) = "/*" Then
                        sBuildingCommand = False
                        sStream = False
                        sCompiledSpew = sCompiledSpew & sTempPuzzle & vbCrLf
                        sTempPuzzle = ""
                        
                        If frmMain.mnuCompileLineFeeds.Checked = True Then 'add crlf if option is on
                            sCompiledSpew = sCompiledSpew & vbCrLf
                        End If
                    
                    End If
                
                'else do nothing, len is < 2
                End If
            Wend
                    
        Close #nScriptFileNum
        nScriptFileNum = FreeFile
        Open sNewFileName For Output As nScriptFileNum
            Print #nScriptFileNum, sCompiledSpew
        Close #nScriptFileNum
        
        MsgBox "Compiled Version Saved As:" & vbCrLf & vbCrLf & sNewFileName, vbOKOnly, "Compiled!"
    Else
        MsgBox "It would be helpful if you had some text in the editor...", vbOKOnly, "eep!"
    End If
    ' Show the compiled output in popup window
    frmPopUp.Caption = "Compiled Output Display [" + sNewFileName + "]"
    frmPopUp.txtMain.Font.Name = "Courier New"
    frmPopUp.txtMain.Font.Size = 8
    frmPopUp.txtMain.Text = sCompiledSpew
    frmPopUp.Show
    
End Function


